jQuery(document).ready(function(){
  
  var rImage = jQuery("#{{uc_id}}");
  var rImageItem = rImage.find(".ue-image-item");
  var rImageTitle = rImage.find(".ue-image-title");
  var rImageBox = rImage.find(".ue-image-box")

    //set image src 
  {% set itemsForJs = get_items() %}
  var rSrcArray = [
      {% for item in itemsForJs %}
      "{{item.image}}",
      {% endfor %}
  ];

  var rSrcArrayNumber = rSrcArray.length;
  var randomNumber = Math.floor(Math.random() * rSrcArrayNumber); 

  var rSrcToLoad = rSrcArray[randomNumber];
  rImageItem.attr("src", rSrcToLoad);  

  //set image title 
  {% set itemsForJs = get_items() %}
  var rTitleArray = [
      {% for item in itemsForJs %}
      "{{item.title|raw}}",
      {% endfor %}
  ]; 

  var rTitleToLoad = rTitleArray[randomNumber];
  rImageTitle.html(rTitleToLoad);

  //set image position 
  {% set itemsForJs = get_items() %}
  var rImagePositionArray = [
    {% for item in itemsForJs %}
      "{{item.image_position}}",
      {% endfor %}
    ];  

     var rImagePositionToLoad = rImagePositionArray[randomNumber];
     rImageItem.css({'object-position': rImagePositionToLoad});

    //check if item has link
    {% set itemsForJs = get_items() %}
    var rIsLinkArray = [
      {% for item in itemsForJs %}
      "{{item.enable_link|raw}}",
      {% endfor %}
    ];

    var hasLink = rIsLinkArray[randomNumber];

    //set image link 
    {% set itemsForJs = get_items() %}
    var rLinkArray = [
      {% for item in itemsForJs %}
      "{{item.link|raw}}",
      {% endfor %}
    ];
     
    //set link attributes
    {% set itemsForJs = get_items() %}
    var rLinkAttributesArray = [
      {% for item in itemsForJs %}
      `{{item.link_html_attributes|raw}}`,
      {% endfor %}
    ];
     
    /*
    * wrap with link
    */
    function wrapElementWithLink(objElement, linkClass, linkHtmlAttributes, href){
    	
      objElement.wrap('<a class="'+linkClass+'" href=""'+linkHtmlAttributes+'></a>');
      
      var objLink = rImage.find("."+linkClass);
      
      objLink.attr("href", href);
    
    } 

    if(hasLink == "true"){
      
      var rLinkAttributes = rLinkAttributesArray[randomNumber];
      var rLinkToLoad = rLinkArray[randomNumber];
            
      wrapElementWithLink(rImageItem, "ue-image-link", rLinkAttributes, rLinkToLoad);
      wrapElementWithLink(rImageTitle, "ue-title-link", rLinkAttributes, rLinkToLoad);
    
    }

    //debug mode	
    var dataDebug = rImage.data("debug");
    var dataEditor = rImage.data("editor");

    if(dataDebug == true && dataEditor == 'yes'){
      var rImageContainer = rImage.children();
      var rImageHtml =  rImageContainer.html();

      //remove link
      if(jQuery(rImageLink).length > 0){
        rImageItem.unwrap();
      }

      for(let i=0;i<rSrcArrayNumber;i++){
        //clone html elements
        rImageContainer.append(rImageHtml);

        var rImageBoxCloned = rImageContainer.children();

        //remove last html element
        rImageBoxCloned.eq(rSrcArrayNumber).remove();

        var rImageElementCloned = rImageBoxCloned.eq(i).find(".ue-image-item");
        var rTitleElementCloned = rImageBoxCloned.eq(i).find(".ue-image-title");

        //set src attribute for each cloned image
        rImageElementCloned.attr('src', rSrcArray[i]);

        //set title for each cloned title element
        rTitleElementCloned.html(rTitleArray[i]);

        //set image position for each cloned image
        rImageElementCloned.css({'object-position': rImagePositionArray[i]});

        //check if cloned image has link
        var hasClonedImageLink = rIsLinkArray[i];

        if(hasClonedImageLink == "true"){

          //wrap each cloned image with <a> tag
          rImageElementCloned.wrap('<a class="ue-image-link" href=""></a>');

          var rLinkElementCloned = rImageBoxCloned.eq(i).find(".ue-image-link");

          //set href attribute for each cloned link
          rLinkElementCloned.attr("href", rLinkArray[i]); 
        }
      }
    }

     
});