jQuery(document).ready(function(){
  
{% if particles_json is empty %}

	var objSettings = {
     "particles":{
        "number":{
           "value":{{number_of_particles}},
           "density":{
              "enable":true,
              "value_area":800
           }
        },
      {% if multi_color == "false" %}
        "color":{
           "value":"{{color}}"
        },{% else %}
        "color":{
           "value":["{{color}}","{{color2}}","{{color3}}","{{color4}}"]
        },{% endif %}
          
        
        "shape":{
           "type":"{{particle_shape}}",
           "stroke":{
              "width":0,
              "color":"#000000"
           },
           "polygon":{
              "nb_sides":{{polygon_sides}}
           },
           "image":{
              "src":"{{particle_image}}",
              "width":{{image_width}},
              "height":{{image_height}}
           }
        },
        "opacity":{
           "value":{{opacity_nounit}},
           "random":{{random_opacity}},
           "anim":{
              "enable":{{animated_opacity}},
              "speed":1,
              "opacity_min":0.1,
              "sync":false
           }
        },
        "size":{
           "value":{{particle_size}},
           "random":{{randomize_size}},
           "anim":{
              "enable":{{pulse_particle}},
              "speed":30,
              "size_min":1,
              "sync":{{sync_pulse}}
           }
        },
        "line_linked":{
           "enable":{{link_line}},
           "distance":150,
           "color":"{{line_color}}",
           "opacity":{{line_opacity_nounit}},
           "width":{{link_width}}
        },
        "move":{
           "enable":true,
           "speed":{{speed}},
           "direction":"{{particle_direction}}",
           "random":{{random_speed}},
           "straight":{{randomize_direction}},
           "out_mode":"out",
           "bounce":false,
           "attract":{
              "enable":false,
              "rotateX":600,
              "rotateY":1200
           }
        }
     },
     "interactivity":{
        "detect_on":"{{mouse_detect_on}}",
        "events":{
           "onhover":{
              "enable":true,
              "mode":
              {% if on_hover == "grab_bubble" %}
              ["grab", "bubble"]
              {% else %}
              "{{on_hover}}"
              {% endif %}  
           },
           "onclick":{
             
              "enable":true,
              "mode":
              {% if on_click == "push_repulse" %}
              ["push", "repulse"]
              {% else %}
              "{{on_click}}"
              {% endif %}  
           },
           "resize":true
        },
        "modes":{
           "grab":{
              "distance":500,
              "line_linked":{
                 "opacity":1
              }
           },
           "bubble":{
              "distance":250,
              "size":{{bubble_size}},
              "duration":0.5,
              "opacity":8,
              "speed":5
           },
           "repulse":{
              "distance":150,
              "duration":0.4
           },
           "push":{
              "particles_nb":8
           },
           "remove":{
              "particles_nb":20
           }
        }
     },
     "retina_detect":false
  }  
                                              
{% else %} 
	var objSettings = {{particles_json|raw}};
{% endif %}	
                 
  particlesJS("{{uc_id}}", objSettings);
  
  var count_particles, stats, update; 
 
  stats = new Stats;
 
  stats.setMode(0);
  stats.domElement.style.position = 'absolute'; 
  stats.domElement.style.left = '0px'; 
  stats.domElement.style.top = '0px';

});