{% if ucfunc("run_code_once", "remote_tabs_code") == true %}

  function initUERemoteTabs(objWidget, objRemoteApi, objParents) {

    var objItems = objWidget.find(".ue-item");
    var classActive = "ue-item-active";
    var g_classActiveWidget = "ue-widget-active";

    var dataParentID = objWidget.data('parentid');
    var isHashSet = objWidget.data('set-hash');
    var dataChangeType = objWidget.data('change-type');
    var g_objTabsWidgets;

    /**
    * set custom attr with parent widget's id
    */
    function setParentIdAttribute(){

      var parentIdArray = [];

      //in case in the future this widget will have several parents
      objParents.each(function(){

        var objParent = jQuery(this);
        var parentId = objParent.attr("id");

        parentIdArray.push(parentId);

      });

      objWidget.attr("data-parents-array", parentIdArray);

    } 

    /*
    *	get tabs widgets that are connected to same parent
    */
    function getRelatedTabsWidgets(){

       //set attribute with parents ids
       setParentIdAttribute();

       var dataParentsArrayAttr = objWidget.data("parents-array");
       var objRelatedTabsWidgets = jQuery('.ue-remote-tabs[data-parents-array="'+dataParentsArrayAttr+'"]');
		
       return(objRelatedTabsWidgets);

    }

    /*
    * set hash
    */
    function setHash(objTab) {

            if(isHashSet == false)
            return(false); 

            var objTabDataId = objTab.data("id");
            var objTabDataCustomHashName = objTab.data("custom-hash");

            if(objTabDataCustomHashName == "")
            window.location.hash = "remote-" + objTabDataId;

            if(objTabDataCustomHashName != "")
            window.location.hash = objTabDataCustomHashName;
    }

    /*
    * get tab object from hash
    */
    function getHashedTab() {

            if(isHashSet == false)
            return(false);

            if (!window.location.hash) 
            return false;

            var HashedTab = window.location.hash.replace("remote-", "").replace("#", "");

            return jQuery('.ue-remote-tabs[data-set-hash="true"] #ue-remote-tabs-'+HashedTab);

    }

    /*
    * set active item
    */
    function setActive(objItem) {

            if (objItem.hasClass(classActive)) 
            return false;

            //remove class from all remote tabs widgets connected to current parent widget

            //find all items inside all parents
            g_objTabsWidgets.each(function(){

                    var objTabWidget = jQuery(this);
                    var objTabWidgetItems = objTabWidget.find('.ue-item');

                    //remove active class from items of each remote tabs parents
                    objTabWidgetItems.removeClass(classActive);
                    
            });
      
      		objItem.addClass(classActive);

            return true;
    }
    
    /**
    * set active class for the whole widget
    */
    function setActiveWidget(objWidget){
      
    	g_objTabsWidgets.removeClass(g_classActiveWidget);
      	objWidget.addClass(g_classActiveWidget);    
    
    }

    /*
    *	change tab
    */
    function changeTab() {

            var objItem = jQuery(this);
      		var objParentWidget = objItem.parents(".ue-remote-tabs");
      
      		//set active widget
      		setActiveWidget(objParentWidget);

            //set hash if needed
            setHash(objItem);

            var isSet = setActive(objItem);

            if (isSet == false) 
            return true;

            var objDataTabNum = objItem.data('tab-number');
            var isDataTabNumSet = objDataTabNum != '';
            var itemNum;

            if(isDataTabNumSet == true)
            itemNum = objDataTabNum;

            if(isDataTabNumSet == false)
            itemNum = objItem.index();
		
            objRemoteApi.doAction("change_item", itemNum);
    }  

    /**
    *	on remote change event
    **/
    function onRemoteChangeEvent(){

            var currentNum = objRemoteApi.doAction("get_num_current");
			
            //check if several remote tabs widgets connected to parent widget
            var remoteTabsWidgetsNumber = g_objTabsWidgets.length;
		
            if(remoteTabsWidgetsNumber == 1){

                    if (currentNum >= objItems.length)
                    currentNum = objItems.length - 1;

                    var objItem = jQuery(objItems[currentNum]);

                    setActive(objItem);

                    return(false);

            }

            if(remoteTabsWidgetsNumber > 1){

                g_objTabsWidgets.each(function(){

                    var objTabWidget = jQuery(this);
                    var objTabWidgetItems = objTabWidget.find('.ue-item');

                    //check each item if it has data-tab-num attr
                    objTabWidgetItems.each(function(){

                        var objTabWidgetItem = jQuery(this);
                        var objDataTabNum = objTabWidgetItem.data('tab-number');
                        var isDataTabNumSet = objDataTabNum !== '';
						
                        //if data tab number not set then do as usual
                        if(isDataTabNumSet == false){
                          
                          	var isWidgetActive = objTabWidget.hasClass(g_classActiveWidget);	
                  
                            //check if widget active
                            if(isWidgetActive == false)
                            return(true); 
							
                            if(objTabWidgetItem.index() != currentNum)
                            return(true);

                            setActive(objTabWidgetItem);
                       
                            return(true);
                          
                        }
                      	
                        //if data tab num not equal to currentNum then skip
                        if(objDataTabNum !== currentNum)
                        return(true);
                                            	      
                        //set active
                        setActive(objTabWidgetItem);
						
                    });

                });

            }

    }



    /*
    * checks if in vieport 
    */
    function isElementInViewport(element) {

      var elementTop = element.offset().top;
      var elementBottom = elementTop + element.outerHeight();

      var viewportTop = jQuery(window).scrollTop();
      var viewportBottom = viewportTop + jQuery(window).height();

      var isInViwport = elementBottom > viewportTop && elementTop < viewportBottom;

      return(isInViwport);
    } 

    /*
    * scrolls to element if needed
    */
    function scrollToHead(elementOffsetTop, dataHashedItemScrollOffset){	

      jQuery('html, body').animate({
          scrollTop: elementOffsetTop + dataHashedItemScrollOffset
      }, 400);

    }

    /*
    * goes to the item on hash
    */
    function checkHashAndTriggerItem(){

     var objHashedItem = getHashedTab();

     if(!objHashedItem.length)
     return(false);

     setTimeout(function(){

       objHashedItem.trigger("click");

       if(dataChangeType == 'hover')
       objHashedItem.trigger("mouseenter");

       var objHashedItemOffsetTop = objHashedItem.offset().top;

       var dataParentScrollToHead = objHashedItem.parents('.ue-remote-tabs').data('scrolltohead');
       var dataHashedItemScrollOffset = objHashedItem.parents('.ue-remote-tabs').data('scrolltohead-offset');

       if(isElementInViewport(objHashedItem) == false && dataParentScrollToHead == true)
       scrollToHead(objHashedItemOffsetTop, dataHashedItemScrollOffset);

     }, 400);   

    }

    /*
    * init tabs
    */
    function initRemoteTabs(){
      
      //init vars
      g_objTabsWidgets = getRelatedTabsWidgets();
      
      //update g_objTabsWidgets var to make sure all tabs are found
      setTimeout(function(){
     	g_objTabsWidgets = getRelatedTabsWidgets();
      },200);
      
      setTimeout(function(){
        
        //check hach and trigger item if needed
        checkHashAndTriggerItem();

        //init events
        objItems.on("click", changeTab);

        if(dataChangeType == 'hover')
        objItems.on("mouseenter", changeTab);

        objRemoteApi.onEvent("change", onRemoteChangeEvent);
      
      },250);

    }

    //init remote tabs
    initRemoteTabs();  

  }
 
{% endif %} //end run_code_once

{{ ucfunc("put_docready_start") }}
		
  var objRemoteApi = new UERemoteWidgets();
  
  objRemoteApi.onWidgetInit("{{uc_id}}",function(objWidget){
      
	  var objParents = objRemoteApi.getParent();
      initUERemoteTabs(objWidget, objRemoteApi, objParents);
    	
      var objRemoteTabs = jQuery("#{{uc_id}}");
    
      objRemoteTabs.on("uc_ajax_refreshed",function(){      
     	initUERemoteTabs(objWidget, objRemoteApi, objParents);    
  	  });
      
  });	
    	
{{ ucfunc("put_docready_end") }}