{{ ucfunc("put_docready_start") }}

	var objWrapper = jQuery("#{{uc_id}}");

	var masonryOptions = {
    
    	container: '#{{uc_id}}',
        gutter: {{gutter}},
        baseWidth: {{basewidth}},
        minify: {{minify}},
        surroundingGutter: {{surroundinggutter}},
        ultimateGutter:	{{ultimategutter}}, 
        direction: "{{direction}}"
    
    }

    var UEMasonryGrid = new MiniMasonry(masonryOptions);

	function onWindowResize(){
    
      // Get the current screen width
      var screenWidth = jQuery(window).width();

      // Set the MiniMasonry.js options based on the screen width
   
      if (screenWidth > 1024) {
        masonryOptions.baseWidth = {{basewidth}};
      } else if (screenWidth > 767) {
        masonryOptions.baseWidth = {{basewidth_tablet}};
      } else {
        masonryOptions.baseWidth = {{basewidth_mobile}};
      }

      // Update the MiniMasonry.js instance with the new options
      UEMasonryGrid = new MiniMasonry(masonryOptions);
    
    }

	jQuery(window).on('resize', onWindowResize);

	//filtering and multisource
	objWrapper.on("uc_ajax_refreshed",function(){
      	UEMasonryGrid.layout();
    });
	
	//truncate custom field text
	function truncateField(objTexts, maxCharNum){
      
      	if(!objTexts.length)
        return(false);  
      
      	objTexts.each(function(){
        
        	var objText = jQuery(this);
       		var customText = objText.text();
          
       		if (customText.length > maxCharNum) {
              
                // Truncate the text and add an ellipsis
                var truncatedText = customText.substring(0, maxCharNum).trim() + "…";
              
                objText.text(truncatedText);
              
            }
        
        });      	
    
    }

	var dataShowCustomField = objWrapper.data("custom-field");
      
    if(dataShowCustomField == true){
    
      var objCustomTexts = objWrapper.find(".masonryPostGridItemText-custom");
      var maxCharNum = objWrapper.data("custom-char-num");

      truncateField(objCustomTexts, maxCharNum);
      
    }
    
    
    {% if show_intro_text == "true" %}
        
      var objTexts = objWrapper.find(".masonryPostGridItemText");
      var maxCharNum = Number("{{intro_number_of_characters}}");
     
      truncateField(objTexts, maxCharNum);
    
    {% endif %}	


{{ ucfunc("put_docready_end") }}