#{{uc_id}} .uc_nav-menu{
	margin: 0;
	padding: 0;
	list-style: none;
	display: flex;
	flex-direction: column;
}

#{{uc_id}} a.ue-menu-item
{
  display:flex;
  position:relative;
  align-items:center;
}

#{{uc_id}} .uc_nav-menu a.ue-menu-item .ue-menu-item-icon
{
  display:inline-block;
  position:relative;
  display:flex;
  align-items:center;
  justify-content:center;
  line-height:1em;
  transition:0.3s;
}

#{{uc_id}} .uc_nav-menu a.ue-menu-item .ue-menu-item-icon svg
{
  width:1em;
  height:1em;
}

#{{uc_id}} .uc_nav-menu a.ue-menu-item .ue-menu-tooltip {
  display: inline-block;
  opacity: 0;
  transition: 0.3s;
  background-color:{{tooltip_background}};
  line-height:1em;
  position: absolute;
  top: 50%;
  inset-inline-start: calc(100% + 14px);
  transform: translate(0, -50%);
  white-space: nowrap;
}




.ue-menu-tooltip
{
  font-size:11px;
}


#{{uc_id}} .uc_nav-menu a.ue-menu-item .ue-menu-tooltip::before {
  display: block;
  position: absolute;
  content: '';
  border-top: 7px solid transparent;
  border-bottom: 7px solid transparent;
  top: 50%;
  
  transition: all .3s ease;
}

{% if menu_direction == "ltr" %}
#{{uc_id}} .uc_nav-menu a.ue-menu-item .ue-menu-tooltip::before {
  border-right: 7px solid {{tooltip_background}};
  left: 0;
  transform: translate(-6px, -50%);
}
{% endif %}
{% if menu_direction == "rtl" %}
#{{uc_id}} .uc_nav-menu a.ue-menu-item .ue-menu-tooltip::before {
  border-left: 7px solid {{tooltip_background}};
  right: 0;
  transform: translate(6px, -50%);
}
{% endif %}
{% if tooltip_show_on_active == "true" %}
#{{uc_id}} .uc_nav-menu a.uc_active .ue-menu-tooltip  {

  opacity: 1;
}   
{% endif %}
{% if tooltip_show_on_hover == "true" %}
  @media only screen and (min-width: 1024px) {
    #{{uc_id}} .uc_nav-menu a.ue-menu-item:hover .ue-menu-tooltip  {
 
    opacity: 1;
  } 
}
{% endif %}